''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' vk5djbat.bas
'
Const Ver = "1.1"
'
'Name of display variables in index.html must be at least the length of the content
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
DIM buff%(4096/8)   
Option ESCAPE
Option EXPLICIT
Option Autorun On, NORESET
'OPTION SYSTEM I2C GP16, GP17'SETUP PINS FOR i2c

Const true = 1
Const false = 0

Const WatchDogOn = true          ' disable for debugging
If WatchDogOn Then WatchDog 20000


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' User changeable constants
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Const DefaultTimeZone = 10.5     ' this is the default timezone if the location is not set

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Const LogToConsole = true   ' set to false if you do NOT want status messages printed to the console

' I/O pins
Option Count GP10, GP6, GP7, GP8
Const RunLed = 25
Const AbortRun = 30


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' general variables
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
 dim Integer i					   ' used in web interrupt
 dim String s
 dim DateStore01$   LENGTH 10	   'store date to hold old data in index.html
 dim DateStore02$   LENGTH 10
 dim DateStore03$   LENGTH 10
 dim DateStore04$   LENGTH 10
 dim DateStore05$   LENGTH 10
 dim DateStore06$   LENGTH 10
 dim DateStore07$   LENGTH 10
 dim DateStore08$   LENGTH 10
 
 dim TimeStore01$   LENGTH 8	   'store time to hold old data in index.html
 dim TimeStore02$   LENGTH 8
 dim TimeStore03$   LENGTH 8
 dim TimeStore04$   LENGTH 8
 dim TimeStore05$   LENGTH 8
 dim TimeStore06$   LENGTH 8
 dim TimeStore07$   LENGTH 8
 dim TimeStore08$   LENGTH 8
 
 dim BatteryVA001$ LENGTH 12		'store Load VA to hold immediate value in index.html (immediate value)
 dim BatteryVA002$ LENGTH 12		'next 7 values are old stored data for use in index.html 
 dim BatteryVA003$ LENGTH 12
 dim BatteryVA004$ LENGTH 12
 dim BatteryVA005$ LENGTH 12
 dim BatteryVA006$ LENGTH 12
 dim BatteryVA007$ LENGTH 12
 dim BatteryVA008$ LENGTH 12
 
 dim SolarVAmp001$ LENGTH 12		'store Solar VA to hold old data in index.html
 dim SolarVAmp002$ LENGTH 12
 dim SolarVAmp003$ LENGTH 12
 dim SolarVAmp004$ LENGTH 12
 dim SolarVAmp005$ LENGTH 12
 dim SolarVAmp006$ LENGTH 12
 dim SolarVAmp007$ LENGTH 12
 dim SolarVAmp008$ LENGTH 12
 
 dim PrintDate001$ LENGTH 12		'display current date etc in index.html
 dim PrintTime001$ LENGTH 8
 dim PrintLoadVA01$ LENGTH 11
 dim PrintSolarVA01$ LENGTH 11
 
 'now the print variables
  Dim PrintDate002$   LENGTH 12
  Dim PrintTime002$   LENGTH 8
  Dim PrintLoadVA02$  LENGTH 12 = "Six AM"
  DIM PrintSolarVA02$ LENGTH 12
  Dim PrintDate003$   LENGTH 12
  Dim PrintTime003$   LENGTH 8
  Dim PrintLoadVA03$  LENGTH 12 = "Nine AM"
  Dim PrintSolarVA03$ LENGTH 12 
  Dim PrintDate004$   LENGTH 12
  Dim PrintTime004$   LENGTH 8
  dim PrintLoadVA04$  LENGTH 12 = "Noon"
  Dim PrintSolarVA04$ LENGTH 12
  Dim PrintDate005$   LENGTH 12
  Dim PrintTime005$   LENGTH 8
  Dim PrintLoadVA05$  LENGTH 12 = "Three PM"
  Dim PrintSolarVA05$ LENGTH 12
  Dim PrintDate006$   LENGTH 12
  Dim PrintTime006$   LENGTH 8
  Dim PrintLoadVA06$  LENGTH 12 = "Six PM"
  Dim PrintSolarVA06$ LENGTH 12
  Dim PrintDate007$   LENGTH 12
  Dim PrintTime007$   LENGTH 8
  Dim PrintLoadVA07$  LENGTH 12 = "Nine PM"
  Dim PrintSolarVA07$ LENGTH 12
  dim TempL as integer			'the next variables are used in the ANA226 calculations
  dim TempH as integer
  dim flipflop as integer = 0
  dim TempSt$ as string
  dim VoltsL$ LENGTH 6
  dim AmpsL$ LENGTH 6  
  dim VoltsS$ LENGTH 6
  dim AmpsS$ LENGTH 6
  dim float voltout			  'last of ANA226 variables
  dim float ampout
  dim VoltH as Integer
  dim VoltL as Integer
  dim Lamps as Integer  	  'load amps
  dim Samps as integer  	  'solar amps
  dim Lvolts as integer 	  'load volts
  dim Svolts as integer 	  'solar volts
  Dim TempF             	  'used in i2c as a real
  dim Temperature$ LENGTH 8 = "23.5"  'print temp from DHT22
  dim HumidValue$ LENGTH 8 = "56"     'print humidity as string
  dim FLOAT temper, humidity          'dimension input from HUMID command
  dim DateNow$ LENGTH 10	'time calcs
  dim TimeNow$ LENGTH 8
  dim Mins$ LENGTH 2
  dim secs$ LENGTH 2
  dim Hrs$ LENGTH 2
  dim hours as Integer
  dim minutes as Integer
  dim seconds as Integer
 
  dim Bool as integer = 0	'used in allocation of old data
  dim Bool1 as integer = 0
 
 'const SaveIn = 24       'define pin in for GP18 on pin 24

 SETPIN 25, DOUT			    'On pin p25 of pico interrupts the PIC on port B.0 and flashes LED
 SETPIN 20, DIN			        'input 5V tolerant fires a save on PICO 20, from port B.1 on PIC portB.1 
 WATCHDOG 40000				    'watchdog 40secs
  
Print "Checking connection to WiFi"
Timer = 0

Do While MM.Info(IP ADDRESS) = "0.0.0.0"
  WATCHDOG 40000
  If Timer > 30000 Then 
	 Print "Timeout - Reboot" 
	 Pause 1500
	 CPU RESTART
  endif 
  if Timer < 2000 Then Print "Waiting for WiFi"
  Pause 1000
  Timer = 0
Loop

Print "Connected.  IP address is " + MM.Info$(ip address)
Print "Getting UTC time"

Timer = 0

Do
  If Timer > 30000 Then 
    Print "Timeout - Reboot"
    Pause 1500 
    CPU RESTART
    Pause 1000
	  Timer = 0
	  Watchdog 40000
  endif
  On error skip
  WEB ntp + 10.5
  If MM.Errno <> 0 And Timer < 3000 Then Print "Waiting for the Internet"
Loop Until MM.Errno = 0

' load all the config and setup values from the file A:/settings.dat
LoadAllConfigVars		'reload old measurements from settings.dat

'write to the ANA 226 config initial settings and calibration on start
SETPIN 21,22,I2C		'set the pins for I2C
i2c open 100,200
'now for first I2C number of $40
 I2C WRITE &H40,&H00,&H03,&H00,&H41,&H27 'First need to write to the config register to set it up
I2C WRITE &H40,&H00,&H03,&H05,&H20,&H00  'set calibration for current register &H05 

'now for second I2C number of $41
 I2C WRITE &H41,&H00,&H03,&H00,&H41,&H27 'First need to write to the config register to set it up
 I2C WRITE &H41,&H00,&H03,&H05,&H02,&H00 'set calibration for current register &H05 
I2C close

WEB TCP INTERRUPT WebInterrupt			 'send to WIFI interrupt

'__________________ Finish of general setup _________________________

' below is the main processing loop

Do
  WatchDog 40000
  'now for my CODE
  FlipLed					'flips the activity led
  WatchDog 40000 
  GetValues
  CreateData
  'extract the integers
  Hrs$ = mid$(Time$,1,2)    'access the clock
  Mins$ = mid$(Time$,4,2)
  Secs$ = mid$(Time$,7,2)
  hours = val(Hrs$)
  minutes = val(mins$)
  Seconds = val(secs$)
'  GetTempHumid
  WatchDog 40000 
Loop

Sub FlipLed					'led flash routine
	If Pin(25) = 1 then
	   pin(25) = 0
	else
	   pin(25) = 1
	endif 
	pause 300
end sub	   

 SUB CreateData       'creates the data for the display      
  if bool = 0 and minutes mod 2 = 0 and seconds = 0 then	'the top line immediate
    WATCHDOG 20000
	GetValues
	bool = 1
  endif
 if Bool1 = 0 then
   if hours = 6 and minutes = 0 and seconds = 0 Then		'At 6.00AM
    GetValues
	PrintDate002$ = PrintDate001$
	PrintTime002$ = PrintTime001$
	PrintLoadVA02$ = PrintLoadVA01$
	PrintSolarVA02$ = PrintSolarVA01$
    bool1 = 1
	SaveAllConfigVars
   endif
   if hours = 9 and minutes = 0 and seconds = 0 Then		'At 9:00AM
    GetValues 
	PrintDate003$ = PrintDate001$
	PrintTime003$ = PrintTime001$
	PrintLoadVA03$ = PrintLoadVA01$
	PrintSolarVA03$ = PrintSolarVA01$
    bool1 = 1
    SaveAllConfigVars	
   endif
   if hours = 12 and minutes = 0 and seconds = 0 Then   	'Midday
    GetValues
	PrintDate004$ = PrintDate001$
	PrintTime004$ = PrintTime001$
	PrintLoadVA04$ = PrintLoadVA01$
	PrintSolarVA04$ = PrintSolarVA01$
	bool1 = 1
	SaveAllConfigVars
   endif
   if hours = 15 and minutes = 0 and seconds = 0 Then    	'Three pm
    GetValues 
	PrintDate005$ = PrintDate001$
	PrintTime005$ = PrintTime001$
	PrintLoadVA05$ = PrintLoadVA01$
	PrintSolarVA05$ = PrintSolarVA01$
	bool1 = 1
	SaveAllConfigVars
   endif
   if hours = 18 and minutes = 0 and seconds = 0 Then 		'Six PM
    GetValues
	PrintDate006$ = PrintDate001$
	PrintTime006$ = PrintTime001$
	PrintLoadVA06$ = PrintLoadVA01$
	PrintSolarVA06$ = PrintSolarVA01$
	bool1 = 1
	SaveAllConfigVars
   endif
   if hours = 21 and minutes = 0 and seconds = 0 Then       'nine pm
    GetValues
	PrintDate007$ = PrintDate001$
	PrintTime007$ = PrintTime001$
	PrintLoadVA07$ = PrintLoadVA01$
	PrintSolarVA07$ = PrintSolarVA01$
	bool1 = 1
	SaveAllConfigVars
   endif
 endif
 if minutes mod 2 <> 0 then bool = 0
 if minutes <> 0 or Seconds <> 0 then bool1 = 0
 END SUB 


 SUB GetINA226SetupLoad 
  SETPIN 21,22,I2C		'set the pins for I2C 
  I2C OPEN 100,200      'speed in Hz, timeout in ms
  
' Get load volts
' register 01 is the shunt voltage while 02 is the bus voltage. 04 is current register
  PAUSE 20							'give ana226 time
  I2C WRITE &H40,&H00,&H01,&H02     'set up register $H02 ready for read of volts
  I2C Read &H40,&H00,&H01,TempH     'read the current              '
  VoltOut = TempH * 0.337 + 0.005	'adjust the voltage
  Tempst$ = format$(VoltOut,"%.3f") 'get the volts in string form          
  voltsL$ = left$(TempSt$,4)
  PAUSE 20
  
 'now to read the load current
  I2C WRITE &H40,&H00,&H01,&H04     'set up ready for read of current
  I2C Read &H40,&H00,&H01,TempH     'get the current after calibration has been set              '
  AmpOut = TempH * 0.0165  + 0.005  'adjust current multiplier
  Tempst$ = format$(Ampout,"%.3f")  'format the current
  AmpsL$ = left$(TempSt$,4)
  print "Load: "voltsL$,"V ",Ampsl$,"A " 'Print volts/amps  on Tera Term
  I2C CLOSE 'close the connection
END SUB

SUB GetINA226SetupSolar
  SETPIN 21,22,I2C		'set the pins for I2C 
  I2C OPEN 100,200
  
'Get solar volts
' register 01 is the shunt voltage while 02 is the bus voltage. 04 is current register
  PAUSE 20						      'short delay to give encoder some breather time
  I2C WRITE &H41,&H00,&H01,&H02       'set up register $H02 ready for read of volts
  I2C Read &H41,&H00,&H01,TempH       'read the current           
  VoltOut = TempH * 0.337 + 0.005	  'adjust the voltage
  Tempst$ = format$(VoltOut,"%.3f")   'get the volts in string form          
  voltsS$ = left$(TempSt$,4)
 
 'now to read the solar current
  PAUSE 20						      'short delay to give encoder some breather time
  I2C WRITE &H41,&H00,&H01,&H04       'set up ready for read of current
  I2C Read &H41,&H00,&H01,TempH       'get the current after calibration has been set           
  AmpOut = TempH * 0.0165'0.0075 + 0.005 
  Tempst$ = format$(Ampout,"%.3f")    'format the current
  AmpsS$ = left$(TempSt$,4)
  print "Solar: ",voltsS$,"V ",AmpsS$,"A "	'Print volts/amps  on TerraTerm
  I2C CLOSE 'close the connection
END SUB

SUB GetValues'this routine will query the INA226 device and build the variable for printing
  GetINA226SetupLoad
'  GetINA226SetupSolar		'I only have one device set up at present. Activate this when other device on line
  PrintDate001$ = Date$+"/"
  PrintTime001$ = Time$
  PrintLoadVA01$  = VoltsL$+"V/"+AmpsL$+"A"
  PrintSolarVA01$  = VoltsS$+"V/"+AmpsS$+"A" 
END SUB

Sub	GetTempHumid				'queries the DHT22
  HUMID Pin(31), Temper, humidity
  Temperature$ = str$(Temper)
  HumidValue$ = str$(humidity)
END SUB

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' the code handling the web server
' it is all driven by interrupts from the web server
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' sub to handle all web server requests
Sub WebInterrupt
  Local integer a%, pnbr, i, j
  Local string name, value

  For a% = 1 To MM.Info(MAX CONNECTIONS)
    LongString CLEAR buff%()
	Do While MM.Info(IP ADDRESS) = "0.0.0.0"
       If Timer > 10000 Then Pause 5000 : CPU RESTART
       Pause 1000
    Loop
	LongString CLEAR buff%()
    WEB TCP READ a%, buff%()
    If LLen(buff%()) > 0 Then
        WEB TRANSMIT PAGE a%,"index.html",4096  
	Endif 
  Next a%
End Sub

Sub SaveAllConfigVars
  Print "Saving config and settings data to A:/settings.dat"
  Open "A:/settings.dat" For output As #1
  Print #1, PrintDate002$
  Print #1, PrintTime002$
  Print #1, PrintLoadVA02$
  Print #1, PrintSolarVA02$
  Print #1, PrintDate003$
  Print #1, PrintTime003$
  Print #1, PrintLoadVA03$
  Print #1, PrintSolarVA03$
  Print #1, PrintDate004$
  Print #1, PrintTime004$
  Print #1, PrintLoadVA04$
  Print #1, PrintSolarVA04$
  Print #1, PrintDate005$
  Print #1, PrintTime005$
  Print #1, PrintLoadVA05$
  Print #1, PrintSolarVA05$
  Print #1, PrintDate006$
  Print #1, PrintTime006$
  Print #1, PrintLoadVA06$
  Print #1, PrintSolarVA06$
  Print #1, PrintDate007$
  Print #1, PrintTime007$
  Print #1, PrintLoadVA07$
  Print #1, PrintSolarVA07$
  Close #1
End Sub

Sub LoadAllConfigVars
  On error skip
  Open "A:/settings.dat" For input As #1
  If MM.Errno Then
    Print "Cannot find file A:/settings.dat"
    Exit Sub
  EndIf
  Print "Loading settings data from A:/settings.dat"
  Line Input #1, PrintDate002$
  Line Input #1, PrintTime002$
  Line Input #1, PrintLoadVA02$
  Line Input #1, PrintSolarVA02$
  Line Input #1, PrintDate003$
  Line Input #1, PrintTime003$
  Line Input #1, PrintLoadVA03$
  Line Input #1, PrintSolarVA03$
  Line Input #1, PrintDate004$
  Line Input #1, PrintTime004$
  Line Input #1, PrintLoadVA04$
  Line Input #1, PrintSolarVA04$
  Line Input #1, PrintDate005$
  Line Input #1, PrintTime005$
  Line Input #1, PrintLoadVA05$
  Line Input #1, PrintSolarVA05$
  Line Input #1, PrintDate006$
  Line Input #1, PrintTime006$
  Line Input #1, PrintLoadVA06$
  Line Input #1, PrintSolarVA06$
  Line Input #1, PrintDate007$
  Line Input #1, PrintTime007$
  Line Input #1, PrintLoadVA07$
  Line Input #1, PrintSolarVA07$
  Close #1
End Sub
